unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, Grids, LCLType, LCLProc;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Memo1: TMemo;
    StringGrid1: TStringGrid;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: char);
    procedure FormShow(Sender: TObject);
    procedure Gauss(var vector: array of extended;
                    var b: array of extended;
                    var x: array of extended;
                    var n: integer);
    procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
    { private declarations }
  public

    { public declarations }
  end; 

var
  Form1: TForm1; 
  n: integer;
  a: array of array of extended; { матрица коэффициентов системы,
  двумерный динамический массив}
  vector: array of extended; {преобразованный одномерный
  динамический массив }
  b: array of extended;
  x: array of extended;

implementation

{ TForm1 }
procedure TForm1.Gauss(var vector: array of extended;
                       var b: array of extended;
                       var x: array of extended;
                       var n: integer);
var
  a: array of array of extended; { матрица коэффициентов системы,
  двумерный динамический массив}
  i, j, k, p, r: integer;
  m, s, t: real;
begin
  try
    SetLength(a, n, n); { установка фактического размера
    массива Преобразование одномерного массива в двумерный }
    k:= 1;
    for i:= 0 to n - 1 do
    for j:= 0 to n - 1 do
    begin
      a[i, j]:= vector[k];
      k:= k + 1;
    end;
    for k:= 0 to n - 2 do
    begin
      for i:= k + 1 to n - 1 do
      begin
        if (a[k, k]= 0) then
        begin
          { перестановка уравнений}
          p:= k; // в алгоритме используется буква l,
                 // но она похожа на 1
                 // Поэтому используем идентификатор p
          for r:= i to n - 1 do
          begin
            if abs(a[r, k]) > abs(a[p, k]) then p:= r;
          end;
          if p <> k then
          begin
            for j:= k to n - 1 do
            begin
              t:= a[k, j];
              a[k, j]:= a[p, j];
              a[p, j]:= t;
            end;
            t:= b[k];
            b[k]:= b[p];
            b[p]:= t;
          end;
        end; // конец блока перестановки уравнений
        m:= a[i, k] / a[k, k];
        a[i, k]:= 0;
        for j:= k + 1 to n - 1 do
        begin
          a[i, j]:= a[i, j] - m * a[k, j];
        end;
        b[i]:= b[i] - m * b[k];
      end;
    end;
    {Проверка существования решения}
    if a[n - 1, n - 1] <> 0  then
    begin
      x[n - 1]:= b[n - 1] / a[n - 1, n - 1];
      for i:= n - 2 downto 0 do
      begin
        s:= 0;
        for j:= i + 1 to n - 1 do
        begin
          s:= s - a[i, j] * x[j];
        end;
        x[i]:= (b[i] + s) / a[i, i];
      end;
      Memo1.Lines.Add('Решение:');
      for i:= 0 to n - 1 do
        Memo1.Lines.Add('x' + IntToStr(i + 1) +
                        '=' + FloatToStr(x[i]));
      end
      else
      if b[n - 1] = 0 then
         Memo1.Lines.Add('Система уравнений' +
                         ' не имеет решения.')
      else
         Memo1.Lines.Add('Система уравнений' +
                 ' имеет бесконечное множество решений.');
  except
    on EInvalidOP do
    Memo1.Lines.Add('Неправильные данные. Система уравнений' +
                    ' не имеет решения.');
    on EMathError do
    Memo1.Lines.Add('Неправильные данные. Система уравнений' +
                    ' не имеет решения.');
    on EZeroDivide do
    Memo1.Lines.Add('Неправильные данные. Система уравнений' +
                    ' не имеет решения.');
    on EOverflow do
    Memo1.Lines.Add('Неправильные данные. Система уравнений' +
                    ' не имеет решения.');
    on EUnderflow do
    Memo1.Lines.Add('Неправильные данные. Система уравнений' +
                    ' не имеет решения.');
    on EAccessViolation do
    Memo1.Lines.Add('Неправильные данные. Система уравнений' +
                    ' не имеет решения.');
  end;
    {освобождение памяти,
     распределенной для динамического массива }
     a:= nil;
end;

procedure TForm1.StringGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_Return)  then
  begin
    if (StringGrid1.Col >= n)   then
    begin
      StringGrid1.Row:= StringGrid1.Row + 1;
      StringGrid1.Col:= 0;
      Key:= 0;
    end;
   end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  StringGrid1.ColCount:= 1;
  StringGrid1.RowCount:= 1;
  Edit1.SetFocus;
  Button3.Visible:= true;
  Button4.Visible:= false;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Memo1.Clear;
  StringGrid1.Clean;
  StringGrid1.ColCount:= 1;
  StringGrid1.RowCount:= 1;
  Edit1.Clear;
  Edit1.SetFocus;
  Button3.Visible:= true;
  Button4.Visible:= false;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  {освобождение памяти,
  распределенной для динамических массивов }
  a:= nil;
  vector:= nil;
  x:= nil;
  b:= nil;
  Close();
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Edit1.SetFocus;
  if Length(Edit1.Text) = 0 // если пустая строка
  then exit;
  n:= StrToInt(Edit1.Text);
  StringGrid1.ColCount:= n + 1;
  StringGrid1.RowCount:= n ;
  Stringgrid1.SetFocus;
  Button3.Visible:= false;
  Button4.Visible:= true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if (StringGrid1.Col >= n)   then
  begin
    StringGrid1.Row:= StringGrid1.Row + 1;
    StringGrid1.Col:= 0;
  end
  else
    StringGrid1.Col:= StringGrid1.Col+1;
end;

procedure TForm1.Button5Click(Sender: TObject);
var i, j, k, code:integer;
begin
  {Установка реальных размеров динамических массивов}
  SetLength(a, n, n);
  SetLength(vector, n * n);
  SetLength(b, n);
  SetLength(x, n);
  for j:= 0 to n - 1 do
  for i:= 0 to n - 1 do
  begin
    val(StringGrid1.Cells[i, j], a[i, j], code);
    if code <> 0 then
    begin
      ShowMessage('Ошибка при вводе коэффициентов матрицы');
      StringGrid1.SetFocus;
      exit;
    end;
  end;
  for j:= 0 to n - 1 do
  begin
    val(StringGrid1.Cells[n, j], b[j], code);
    if code <> 0 then
    begin
      ShowMessage('Ошибка при вводе свободных членов');
      StringGrid1.SetFocus;
      exit;
    end;
  end;
  code:=0;
  {Преобразование двумерного массива в одномерный}
  k:= 1;
  for j:= 0 to n - 1 do
  for i:= 0 to n - 1 do
  begin
    vector[k]:= a[i, j];
    k:= k + 1;
  end;
  {Вызов процедуры решения системы линейных
  алгебраических уравнений методом Гаусса}
  Gauss(vector, b, x, n);
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: char);
begin
if Key = #13 then
  begin
    if Length(Edit1.Text) = 0  // если пустая строка
    then exit;
    n:=StrToInt(Edit1.Text);
    StringGrid1.ColCount:= n + 1;
    StringGrid1.RowCount:= n ;
    Stringgrid1.SetFocus;
    exit;
  end;
  { разрешаем только цифры, знак минус и кл. BackSpace}
  if not (Key in ['0' .. '9', #8])
  then
  begin
    Key:= #0;
    exit;
  end;
end;


initialization
  {$I Unit1.lrs}

end.

